assert(load(assert(builder:open_text("setup_utility.lua"))))()
builder:set_default_size(30, 30)
standard_setup({
  main = {"advanced_level_utility.lua", "level_logic.lua"},
  blocks = {"Red.png", "Blue.png", "Green.png"},
  info_panel = {
    {tab = "Goal", contents = {
      info_title("Specification"),
      low_level_figure({
        {object = "red_in1", height = 0.25, position = Vectord.new(0, 0)},
        {object = "blue_in1", height = 0.25, position = Vectord.new(0, -0.3)},
        {text = "Input 0:", height = 0.06, position = Vectord.new(-0.55, 0), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {text = "Input 1:", height = 0.06, position = Vectord.new(-0.55, -0.3), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0, -0.5)},
        {object = "out1", height = 0.25, position = Vectord.new(0, -0.7)},
        {box = Rectangled.new(-0.275, 0.15, -0.1, -0.85), thickness = 0.01},
        {text = "Output:", height = 0.06, position = Vectord.new(-0.55, -0.7), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}}
      }),
      info_desc("A series of pairs of red and blue objects consisting of 8 columns of height 1 or 2 will be input. Wherever the two objects have columns of equal height, the output should have a column of height 1. Wherever the two objects have columns of different height, the output should have a column of height 2.\n See Table and Examples for further detail.")
    }},
    {tab = "Table", contents = {
      info_title("Table"),
      low_level_figure({
        {object = "short_red", height = 0.1, position = Vectord.new(-0.45, 0), align_vertical = ALIGN_LOWER},
        {object = "short_red", height = 0.1, position = Vectord.new(-0.15, 0), align_vertical = ALIGN_LOWER},
        {object = "tall_red", height = 0.2, position = Vectord.new(0.15, 0), align_vertical = ALIGN_LOWER},
        {object = "tall_red", height = 0.2, position = Vectord.new(0.45, 0), align_vertical = ALIGN_LOWER},

        {object = "short_blue", height = 0.1, position = Vectord.new(-0.45, -0.3), align_vertical = ALIGN_LOWER},
        {object = "tall_blue", height = 0.2, position = Vectord.new(-0.15, -0.3), align_vertical = ALIGN_LOWER},
        {object = "short_blue", height = 0.1, position = Vectord.new(0.15, -0.3), align_vertical = ALIGN_LOWER},
        {object = "tall_blue", height = 0.2, position = Vectord.new(0.45, -0.3), align_vertical = ALIGN_LOWER},

        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(-0.45, -0.4)},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(-0.15, -0.4)},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0.15, -0.4)},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0.45, -0.4)},

        {object = "short_green", height = 0.1, position = Vectord.new(-0.45, -0.7), align_vertical = ALIGN_LOWER},
        {object = "tall_green", height = 0.2, position = Vectord.new(-0.15, -0.7), align_vertical = ALIGN_LOWER},
        {object = "tall_green", height = 0.2, position = Vectord.new(0.15, -0.7), align_vertical = ALIGN_LOWER},
        {object = "short_green", height = 0.1, position = Vectord.new(0.45, -0.7), align_vertical = ALIGN_LOWER}
      }),
      info_desc("Each column of this table shows, for every combination of column heights in the red and blue inputs, what the corresponding column in the green output should be.")
    }},
    {tab = "Examples", contents = {
      info_title("Examples"),
      low_level_figure({
        {object = "red_in2", height = 0.2, position = Vectord.new(0, 0)},
        {object = "blue_in2", height = 0.2, position = Vectord.new(0, -0.25)},
        {text = "Input 0:", height = 0.06, position = Vectord.new(-0.55, 0), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {text = "Input 1:", height = 0.06, position = Vectord.new(-0.55, -0.25), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0, -0.425)},
        {object = "out2", height = 0.2, position = Vectord.new(0, -0.6)},
        {text = "Output:", height = 0.06, position = Vectord.new(-0.55, -0.6), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}}
      }),
      info_vspace(0.05),
      low_level_figure({
        {object = "red_in3", height = 0.2, position = Vectord.new(0, 0)},
        {object = "blue_in3", height = 0.2, position = Vectord.new(0, -0.25)},
        {text = "Input 0:", height = 0.06, position = Vectord.new(-0.55, 0), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {text = "Input 1:", height = 0.06, position = Vectord.new(-0.55, -0.25), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0, -0.425)},
        {object = "out3", height = 0.2, position = Vectord.new(0, -0.6)},
        {text = "Output:", height = 0.06, position = Vectord.new(-0.55, -0.6), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}}
      })
    }}
  },
  standard_resize = true
})
